
#include "tuiLoader.h"
#include "tiny_ui_platform.h"

//#include <stdio.h>
#include <string.h>

void tuiLoader_getBounds(float* bounds, uint8_t *data)
{
    tuiDataBase_t *dbb;
    dbb = (tuiDataBase_t *)data;
    tuiObject_t tuiObj;
    tuiObject_read(&tuiObj, TUIOBJECTADDRESS(dbb,0));
    bounds[0] = tuiObj.path.bounding_box[0];
    bounds[1] = tuiObj.path.bounding_box[1];
    bounds[2] = tuiObj.path.bounding_box[2];
    bounds[3] = tuiObj.path.bounding_box[3];
    for(int j =1; j < dbb->numObjects; j++)
    {
      tuiObject_read(&tuiObj, TUIOBJECTADDRESS(dbb,j));
      if(tuiObj.path.bounding_box[0]<bounds[0])   bounds[0] = tuiObj.path.bounding_box[0];
      if(tuiObj.path.bounding_box[1]<bounds[1])   bounds[1] = tuiObj.path.bounding_box[1];
      
      if(tuiObj.path.bounding_box[2]>bounds[2])   bounds[2] = tuiObj.path.bounding_box[2];
      if(tuiObj.path.bounding_box[3]>bounds[3])   bounds[3] = tuiObj.path.bounding_box[3];
    }   
}

void tuiObject_read(struct tuiObject* svgto, uint8_t* buffer)
{	
	memset(svgto, 0, sizeof(struct tuiObject));		
	memcpy(svgto->name, buffer, sizeof(svgto->name)); buffer += sizeof(svgto->name);		
	memcpy(&svgto->matrix, buffer, sizeof(svgto->matrix)); buffer += sizeof(svgto->matrix);
	memcpy(&svgto->blend, buffer, sizeof(uint8_t)); buffer += sizeof(uint8_t);
	memcpy(&svgto->color, buffer, sizeof(svgto->color)); buffer += sizeof(svgto->color);
	memcpy(&svgto->path.bounding_box, buffer, sizeof(svgto->path.bounding_box)); buffer += sizeof(svgto->path.bounding_box);
	memcpy(&svgto->path.quality, buffer, sizeof(uint8_t)); buffer += sizeof(uint8_t);
	memcpy(&svgto->path.format, buffer, sizeof(uint8_t)); buffer += sizeof(uint8_t);
	memcpy(&svgto->path.path_length, buffer, sizeof(svgto->path.path_length)); buffer += sizeof(svgto->path.path_length);	
	svgto->path.path = buffer; buffer += svgto->path.path_length;        
	svgto->path.uploaded = NULL;
}

void tuiLoader_draw(uint8_t *data, tiny_ui_buffer_t *fbuffer, tiny_ui_matrix_t *matrix)
{
    tuiObject_t tuiObj;
    //float bounds[4];
    tuiDataBase_t *dbb;
    dbb = (tuiDataBase_t *)data;
    //tuiLoader_getBounds(bounds,dbb);
    for(int j =0; j < dbb->numObjects; j++)
    {
      
      uint8_t *buffer;
      uint32_t color;
      tuiObject_read(&tuiObj, TUIOBJECTADDRESS(dbb,j));        
      color = 0xff000000 | tuiObj.color;
      //tiny_ui_Scale(0.4f, 0.4f, &matrix);
      //tiny_ui_Translate(-bounds[0],-bounds[1],&matrix);
      tiny_ui_draw(fbuffer, &tuiObj.path, TINY_UI_FILL_NON_ZERO, matrix, tuiObj.blend, color);           
    }
}

